package data.scripts.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipAPI.HullSize;

public class SWP_CargoExpansion extends BaseHullMod {

    public static final float CARGO_BONUS0 = 30f;
    public static final float CARGO_BONUS1 = 60f;
    public static final float CARGO_BONUS2 = 90f;
    public static final float CARGO_BONUS3 = 150f;

    @Override
    public void applyEffectsBeforeShipCreation(HullSize hullSize, MutableShipStatsAPI stats, String id) {
        if (hullSize == HullSize.FRIGATE) {
            stats.getCargoMod().modifyFlat(id, CARGO_BONUS0);
        }
        if (hullSize == HullSize.DESTROYER) {
            stats.getCargoMod().modifyFlat(id, CARGO_BONUS1);
        }
        if (hullSize == HullSize.CRUISER) {
            stats.getCargoMod().modifyFlat(id, CARGO_BONUS2);
        }
        if (hullSize == HullSize.CAPITAL_SHIP) {
            stats.getCargoMod().modifyFlat(id, CARGO_BONUS3);
        }
    }

    @Override
    public String getDescriptionParam(int index, HullSize hullSize) {
        if (index == 0) {
            return "" + (int) CARGO_BONUS0;
        }
        if (index == 1) {
            return "" + (int) CARGO_BONUS1;
        }
        if (index == 2) {
            return "" + (int) CARGO_BONUS2;
        }
        if (index == 3) {
            return "" + (int) CARGO_BONUS3;
        }
        return null;
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getVariant().hasHullMod("diableavionics_cramped")) {
            return "Cannot be installed on a cramped hull";
        }
        if (ship.getVariant().hasHullMod("additional_crew_quarters")) {
            return "Incompatible with Expanded Crew Quarters";
        }
        if (ship.getVariant().hasHullMod("fuel_expansion")) {
            return "Incompatible with Expanded Fuel Tanks";
        }

        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return ship != null && !ship.getVariant().getHullMods().contains("additional_crew_quarters")
                && !ship.getVariant().getHullMods().contains("fuel_expansion")
                && !ship.getVariant().getHullMods().contains("diableavionics_cramped");
    }
}
